// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef FilenameMessageArg_INCLUDED
#define FilenameMessageArg_INCLUDED 1

#include "MessageArg.H"
#include "CString.H"
#include "rtti.H"

class FilenameMessageArg : public EntityManagerMessageArg {
  RTTI_CLASS
public:
  FilenameMessageArg(const CString &);
  MessageArg *copy() const;
  const CString &filename() const;
private:
  CString filename_;
};

inline
const CString &FilenameMessageArg::filename() const
{
  return filename_;
}

#endif /* not FilenameMessageArg_INCLUDED */
