// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include "IdentityCodingSystem.H"
#include <iostream.h>

class IdentityDecoder : public Decoder {
public:
  size_t decode(Char *to, const char *from, size_t fromLen,
		const char **rest);
  Boolean convertOffset(unsigned long &offset) const;
};

class IdentityEncoder : public Encoder {
public:
  IdentityEncoder();
  ~IdentityEncoder();
  void output(Char *, size_t, streambuf *);
  void output(const Char *, size_t, streambuf *);
private:
  void allocBuf(size_t);
  char *buf_;
  size_t bufSize_;
};

IdentityCodingSystem::IdentityCodingSystem()
{
}

Decoder *IdentityCodingSystem::makeDecoder() const
{
  return new IdentityDecoder;
}

Encoder *IdentityCodingSystem::makeEncoder() const
{
  return new IdentityEncoder;
}

size_t IdentityDecoder::decode(Char *to, const char *from, size_t fromLen,
			       const char **rest)
{
  if (sizeof(Char) == sizeof(char) && from == (char *)to) {
    *rest = from + fromLen;
    return fromLen;
  }
  for (size_t n = fromLen; n > 0; n--)
    *to++ = (unsigned char)*from++; // zero extend
  *rest = from;
  return fromLen;
}

Boolean IdentityDecoder::convertOffset(unsigned long &) const
{
  return true;
}

IdentityEncoder::IdentityEncoder()
: buf_(0), bufSize_(0)
{
}

IdentityEncoder::~IdentityEncoder()
{
  delete [] buf_;
}

void IdentityEncoder::allocBuf(size_t n)
{
  if (bufSize_ < n) {
    delete [] buf_;
    buf_ = new char[bufSize_ = n];
  }
}

// FIXME handle errors from streambuf::sputn

void IdentityEncoder::output(Char *s, size_t n, streambuf *sb)
{
  char *p = (char *)s;
  if (sizeof(Char) != sizeof(char)) {
    // FIXME what to do if s[i] > UCHAR_MAX
    for (size_t i = 0; i < n; i++)
      p[i] = (char)s[i];
  }
  sb->sputn(p, n);
}

void IdentityEncoder::output(const Char *s, size_t n, streambuf *sb)
{
  if (sizeof(Char) != sizeof(char)) {
    allocBuf(n);
    // FIXME what to do if s[i] > UCHAR_MAX
    for (size_t i = 0; i < n; i++)
      buf_[i] = (char)s[i];
    sb->sputn(buf_, n);
  }
  else
    sb->sputn((const char *)s, n);
}
