// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef OffsetOrderedList_INCLUDED
#define OffsetOrderedList_INCLUDED 1

#include "types.H"
#include "GrowableVectorD.H"
#include "Boolean.H"
#include "DOwner.H"

struct OffsetOrderedListBlock {
  Offset offset;		// next Offset
  size_t nextIndex;		// index of first item in next block
  enum { size = 200 };
  unsigned char bytes[size];
};

// This is an ordered list of Offsets with no duplicates.

class OffsetOrderedList {
public:
  OffsetOrderedList();
  OffsetOrderedList(const OffsetOrderedList &);	// undefined
  void operator=(const OffsetOrderedList &);	// undefined
  // off must be > the last offset added.
  void append(Offset off);
  // Find the last offset in the list <= off.
  Boolean findPreceding(Offset off, size_t &foundIndex, Offset &foundOffset)
    const;
  size_t length() const;
private:
  void addByte(unsigned char b);
  // bytes used in current block
  int blockUsed_;
  GrowableVectorD<DOwner<OffsetOrderedListBlock> > blocks_;
};

inline
size_t OffsetOrderedList::length() const
{
  return blocks_.length() == 0 ? 0 : blocks_.last()->nextIndex;
}

#endif /* not OffsetOrderedList_INCLUDED */
