// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Portable_INCLUDED
#define Portable_INCLUDED 1

#include "Boolean.H"
#include "CString.H"
#include "Vector.H"
#include "types.H"
#include "SubstTable.H"


// This is for inclusion in applications that use the Portable Entity Manager.

class EntityManager;
class PortableEntityManager;
class StorageManager;
class InputSource;
class Location;
class InputCodingSystem;
class CharsetInfo;
class ExternalEntity;
class InputContext;
class ExternalInfo;
class UnivCharsetDesc;

struct StorageObjectSpec {
  StorageObjectSpec();
  void destruct() { this->StorageObjectSpec::~StorageObjectSpec(); }
  const char *storageType;
  const char *codingSystem;
  CString id;
};

class Portable {
public:
  Portable(StorageManager *defaultStorageManager,
	   const InputCodingSystem *defaultCodingSystem);
  ~Portable();
  // Returned pointer is valid only while `this' exists.
  EntityManager *entityManager();
  InputSource *openDocumentEntity(const CString *sysids,
				  size_t nSysids,
				  const UnivCharsetDesc &,
				  InputContext &);
  void registerStorageManager(StorageManager *);
  void registerCodingSystem(const char *, const InputCodingSystem *);
  void addCatalogSysid(const CString &str, Boolean mustExist = 0);
  Boolean getExternalEntityStorage(const ExternalEntity &entity,
				   const CharsetInfo &docCharset,
				   const SubstTable<Char> *subst,
				   const CString &pero,
				   InputContext &ic,
				   GrowableVectorD<StorageObjectSpec> &specs);
  static const char *messageText(int);
  static const char messageSource[];
  static Boolean externalize(const ExternalInfo *,
			     Offset,
			     const StorageObjectSpec *&sos,
			     unsigned long &lineno,
			     unsigned long &colno,
			     unsigned long &byteIndex);
private:
  Portable(const Portable &);		// not defined
  Portable &operator=(const Portable &); // not defined
  PortableEntityManager *em_;
};

#endif /* not Portable_INCLUDED */
