// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef PosixStorage_INCLUDED
#define PosixStorage_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "StorageManager.H"
#include "DescriptorManager.H"
#include "CString.H"
#include "CharsetInfo.H"

class InputContext;
class CharsetInfo;
class UnivCharsetDesc;
class Filename;
class OutputCodingSystem;

class PosixStorageManager : public StorageManager {
public:
  PosixStorageManager(const char *type,
		      const UnivCharsetDesc &filenameCharset,
		      const OutputCodingSystem *filenameCodingSystem,
		      int maxFDs);
  StorageObject *makeStorageObject(const CString &id,
				   InputContext &);
  void mergeId(CString &id, const CString &specId);
  const char *type() const;
  static const char messageSource[];
  static const char *messageText(int);
private:
  PosixStorageManager(const PosixStorageManager &); // undefined
  void operator=(const PosixStorageManager &);	    // undefined
  DescriptorManager descriptorManager_;
  const OutputCodingSystem *filenameCodingSystem_;
  const char *type_;
};

class PosixFdStorageManager : public StorageManager {
public:
  PosixFdStorageManager(const char *type,
			const UnivCharsetDesc &filenameCharset);
  StorageObject *makeStorageObject(const CString &id,
				   InputContext &);
  const char *type() const;
  static const char messageSource[];
  static const char *messageText(int);
private:
  PosixFdStorageManager(const PosixFdStorageManager &); // undefined
  void operator=(const PosixFdStorageManager &);	    // undefined
  const char *type_;

};

#endif /* not PosixStorage_INCLUDED */
