// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef StdioStorage_INCLUDED
#define StdioStorage_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "StorageManager.H"
#include "DescriptorManager.H"
#include "CString.H"
#include "CharsetInfo.H"

class InputContext;
class CharsetInfo;
class UnivCharsetDesc;
class OutputCodingSystem;

class StdioStorageManager : public StorageManager {
public:
  StdioStorageManager(const char *type,
		      const UnivCharsetDesc &filenameCharset,
		      const OutputCodingSystem *filenameCodingSystem);
  StorageObject *makeStorageObject(const CString &id,
				   InputContext &);
  void mergeId(CString &id, const CString &specId);
  const char *type() const;
  static const char messageSource[];
  static const char *messageText(int);
private:
  StdioStorageManager(const StdioStorageManager &); // undefined
  void operator=(const StdioStorageManager &);	    // undefined
  const OutputCodingSystem *filenameCodingSystem_;
  const char *type_;
};

#endif /* not StdioStorage_INCLUDED */
