// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef StorageManager_INCLUDED
#define StorageManager_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

class DescriptorManager;
class InputContext;

#include "CString.H"
#include "types.H"
#include "CharsetInfo.H"
#include <stddef.h>

class StorageManager;
class CharsetInfo;
class InputContext;

class StorageObject {
public:
  StorageObject();
  virtual ~StorageObject();
  virtual Boolean open(InputContext &, Boolean mayRewind,
		       size_t &blockSize) = 0;
  virtual Boolean read(char *buf, size_t bufSize, InputContext &ic,
		       size_t &nread) = 0;
  virtual Boolean rewind(InputContext &) = 0;
  virtual void willNotRewind();
private:
  StorageObject(const StorageObject &);	// undefined
  void operator=(const StorageObject &); // undefined
};

class StorageManager {
public:
  StorageManager(const UnivCharsetDesc &idCharset);
  virtual StorageObject *makeStorageObject(const CString &id,
					   InputContext &) = 0;
  virtual const char *type() const = 0;
  virtual ~StorageManager();
  const CharsetInfo &idCharset() const;
  virtual void mergeId(CString &id, const CString &specId);
private:
  StorageManager(const StorageManager &); // undefined
  void operator=(const StorageManager &); // undefined
  CharsetInfo idCharset_;
};

inline
const CharsetInfo &StorageManager::idCharset() const
{
  return idCharset_;
}

#endif /* not StorageManager_INCLUDED */
