// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Allocator_INCLUDED
#define Allocator_INCLUDED 1

#include <stddef.h>

class Allocator {
public:
  Allocator(size_t maxSize, unsigned blocksPerSegment);
  Allocator(const Allocator &);	// not defined
  Allocator &operator=(const Allocator &); // not defined
  ~Allocator();
  void *alloc(size_t);
  static void *allocSimple(size_t);
  static void free(void *);
private:
#if 1
public:
#endif
  union ForceAlign {
    unsigned long n;
    struct {
      char c;
    } s;
    char *cp;
    long *lp;
  };
  struct SegmentHeader;
  union BlockHeader;
  friend union BlockHeader;
  union BlockHeader {
    SegmentHeader *seg;
    ForceAlign align;
  };
  class Block;
  friend class Block;
  struct Block {
    BlockHeader header;
    Block *next;
  };
#if 1
private:
#endif
  friend class SegmentHeader;
  struct SegmentHeader {
    union {
      Block **freeList;
      ForceAlign align;
    };
    unsigned liveCount;
    SegmentHeader *next;
  };
  Block *freeList_;
  size_t objectSize_;
  unsigned blocksPerSegment_;
  SegmentHeader *segments_;
  void *alloc1();
  void tooBig(size_t);
};

#endif /* not Allocator_INCLUDED */
