// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include "CopyGrowableVectorD.H"
#include "new.H"

template<class T>
CopyGrowableVectorD<T>::CopyGrowableVectorD()
{
}

template<class T>
CopyGrowableVectorD<T>::CopyGrowableVectorD(size_t n)
: GrowableVectorD<T>(n)
{
}

template<class T>
CopyGrowableVectorD<T>::CopyGrowableVectorD(const CopyGrowableVectorD<T> &v)
{
  if (v.length_ > 0) {
    ptr_ = (T *)::operator new(v.length_*sizeof(T));
    alloc_ = length_ = v.length_;
    for (size_t i = 0; i < length_; i++)
      (void)new (ptr_ + i) T(v.ptr_[i]);
  }
  else
    alloc_ = 0;			// ptr_ and length_ are zero'ed by base
}

template<class T>
CopyGrowableVectorD<T> &CopyGrowableVectorD<T>::operator=(const CopyGrowableVectorD<T> &v)
{
  // not as efficient as possible
  setLength(v.length());
  for (size_t i = 0; i < v.length(); i++)
    ptr_[i] = v[i];
  return *this;
}
