// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include "CopyVector.H"
#include <stddef.h>

template<class T>
CopyVector<T>::CopyVector()
{
}

template<class T>
CopyVector<T>::CopyVector(size_t length)
: Vector<T>(length)
{
}

template<class T>
CopyVector<T>::CopyVector(const CopyVector<T> &v)
{
  length_ = v.length_;
  if (length_ > 0) {
    ptr_ = new T[length_];
    for (size_t i = 0 ; i < length_; i++)
      ptr_[i] = v.ptr_[i];
  }
  else
    ptr_ = 0;
}

template<class T>
CopyVector<T>::CopyVector(const T *v, size_t length)
{
  length_ = length;
  if (length > 0) {
    ptr_ = new T[length];
    for (size_t i = 0; i < length; i++)
      ptr_[i] = v[i];
  }
  else
    ptr_ = 0;
}

template<class T>
CopyVector<T> &CopyVector<T>::operator=(const CopyVector<T> &v)
{
  if (&v == this)
    return *this;
  if (v.length_ > length_) {
    if (ptr_)
      delete [] ptr_;
    ptr_ = new T[v.length_];
  }
  length_ = v.length_;
  for (size_t i = 0 ; i < length_; i++)
    ptr_[i] = v.ptr_[i];
  return *this;
}

template<class T>
void CopyVector<T>::setLength(size_t length)
{
  if (length == 0) {
    if (ptr_ != 0)
      delete [] ptr_;
    length_ = 0;
    ptr_ = 0;
  }
  else if (length <= length_)
    length_ = length;
  else {
    T *ptr = new T[length];
    if (length_ > 0) {
      for (size_t i = 0; i < length_; i++)
	ptr[i] = ptr_[i];
      delete [] ptr_;
    }
    ptr_ = ptr;
    length_ = length;
  }
}
