// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef CopyVector_INCLUDED
#define CopyVector_INCLUDED 1

#include "Vector.H"

template<class T>
class CopyVector : public Vector<T> {
public:
  CopyVector();
  CopyVector(size_t);
  CopyVector(const T *, size_t);
  CopyVector(const CopyVector<T> &);
  CopyVector<T> &operator=(const CopyVector<T> &);
  void setLength(size_t);
  void destruct() { this->CopyVector<T>::~CopyVector(); }
  
};

#ifdef DEFINE_TEMPLATES
#include "CopyVector.C"
#endif

#endif /* not CopyVector_INCLUDED */
