// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef DOwner_INCLUDED
#define DOwner_INCLUDED 1

template<class T>
class DOwner {
public:
  DOwner() : p_(0) { }
  DOwner(T *p) : p_(p) { }
  DOwner(const DOwner<T> &);	// undefined
  void operator=(const DOwner<T> &o); // undefined
  ~DOwner() { if (p_) delete p_; }
  void operator=(T *p) {
    if (p_) delete p_;
    p_ = p;
  }
  T *pointer() const { return p_; }
  operator int() const { return p_ != 0; }
  T *operator->() const { return p_; }
  T &operator*() const { return *p_; }
  void exch(DOwner<T> &x) {
    T *tem = p_;
    p_ = x.p_;
    x.p_ = tem;
  }
  T *extract() {
    T *tem = p_;
    p_ = 0;
    return tem;
  }
  void moveTo(DOwner<T> &to) {
    if (to.p_)
      delete to.p_;
    to.p_ = p_;
    p_ = 0;
  }
  void destruct() { this->DOwner<T>::~DOwner(); }
  void clear() {
    if (p_) {
      delete p_;
      p_ = 0;
    }
  }
private:
  T *p_;
};

#endif /* not DOwner_INCLUDED */
