// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef DOwnerBase_INCLUDED
#define DOwnerBase_INCLUDED 1

class DOwnerBase {
public:
  DOwnerBase() : p_(0) { }
  DOwnerBase(Dtor *p) : p_(p) { }
  DOwnerBase(const DOwnerBase &);	// undefined
  void operator=(const DOwnerBase &o); // undefined
  ~DOwnerBase() { if (p_) delete p_; }
  void operator=(Dtor *p) {
    if (p_) delete p_;
    p_ = p;
  }
  Dtor *pointer() const { return (Dtor *)p_; }
  operator int() const { return p_ != 0; }
  Dtor *operator->() const { return (Dtor *)p_; }
  T &operator*() const { return *(Dtor *)p_; }
  void exch(DOwnerBase &x) {
    Dtor *tem = p_;
    p_ = x.p_;
    x.p_ = tem;
  }
  Dtor *extract() {
    Dtor *tem = (Dtor *)p_;
    p_ = 0;
    return tem;
  }
  void moveTo(DOwnerBase &to) {
    if (to.p_)
      delete to.p_;
    to.p_ = p_;
    p_ = 0;
  }
  void destruct() { this->DOwnerBase::~DOwnerBase(); }
  void clear() {
    if (p_) {
      delete p_;
      p_ = 0;
    }
  }
  void clear();
private:
  Dtor *p_;
};

#endif /* not DOwnerBase_INCLUDED */
