// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include "Exception.H"

RTTI_DEF0(Exception)

RTTI_DEF1(FileException, Exception)

RTTI_DEF1(FdException, Exception)

FileException::FileException(const char *f, const char *s, int n)
: filename(f),
  syscall(s),
  errnum(n)
{
}

FdException::FdException(int d, const char *s, int n)
: fd(d),
  syscall(s),
  errnum(n)
{
}
