// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Exception_INCLUDED
#define Exception_INCLUDED 1

#include "rtti.H"

class Exception {
  RTTI_CLASS
public:
  // Application defines this.
  static void handle(const Exception &);
};

#define THROW(e) Exception::handle(e)

class FileException : public Exception {
  RTTI_CLASS
public:
  FileException(const char *filename, const char *syscall, int errnum);
  const char *filename;
  const char *syscall;
  int errnum;
};

class FdException : public Exception {
  RTTI_CLASS
public:
  FdException(int fd, const char *syscall, int errnum);
  int fd;
  const char *syscall;
  int errnum;
};

#endif /* not Exception_INCLUDED */
