// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef GrowableVector_INCLUDED
#define GrowableVector_INCLUDED 1

#include "VectorBase.H"

#include <stddef.h>

template<class T>
class GrowableVector : public VectorBase<T> {
public:
  GrowableVector();
  ~GrowableVector();
  GrowableVector(size_t);
  GrowableVector(const GrowableVector<T> &);
  GrowableVector<T> &operator=(const GrowableVector<T> &);
  // increase length by 1, return reference to last
  T &grow();
  void setLength(size_t);
  void moveTo(GrowableVector<T> &to);
  void clear();
  void append(const GrowableVector<T> &);
private:
  size_t alloc_;		// allocated size
};

#ifdef DEFINE_TEMPLATES
#include "GrowableVector.C"
#endif

#endif /* not GrowableVector_INCLUDED */
