// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include <stddef.h>
#include <string.h>
#include "new.H"

template<class T>
GrowableVectorD<T>::GrowableVectorD()
: alloc_(0)
{
}

template<class T>
GrowableVectorD<T>::GrowableVectorD(size_t n)
: alloc_(0)
{
  setLength(n);
}

template<class T>
GrowableVectorD<T>::~GrowableVectorD()
{
  for (size_t i = 0; i < length_; i++)
    ptr_[i].destruct();
  if (ptr_)
    ::operator delete((void *)ptr_);
}

template<class T>
T &GrowableVectorD<T>::grow()
{
  if (length_ >= alloc_) {
    alloc_ = alloc_ == 0 ? 8 : alloc_*2;
    void *p = ::operator new(alloc_*sizeof(T));
    if (ptr_) {
      memcpy(p, ptr_, length_*sizeof(T));
      ::operator delete((void *)ptr_);
    }
    ptr_ = (T *)p;
  }
  (void)new (ptr_ + length_) T;
  return ptr_[length_++];
}

template<class T>
void GrowableVectorD<T>::setLength(size_t length)
{
  if (length < length_) {
    for (size_t i = length; i < length_; i++)
      ptr_[i].destruct();
    length_ = length;
  }
  else if (length > length_) {
    if (length > alloc_) {
      alloc_ *= 2;
      if (length > alloc_)
	alloc_ += length;
      void *p = ::operator new(alloc_*sizeof(T));
      if (ptr_) {
	memcpy(p, ptr_, length_*sizeof(T));
	::operator delete((void *)ptr_);
      }
      ptr_ = (T *)p;
    }
    for (size_t i = length_; i < length; i++)
      (void)new (ptr_ + i) T;
    length_ = length;
  }
}

template<class T>
void GrowableVectorD<T>::clear()
{
  if (alloc_ != 0) {
    for (size_t i = 0; i < length_; i++)
      ptr_[i].destruct();
    ::operator delete((void *)ptr_);
    ptr_ = 0;
    alloc_ = 0;
    length_ = 0;
  }
}

template<class T>
void GrowableVectorD<T>::moveTo(GrowableVectorD<T> &to)
{
  to.clear();
  to.ptr_ = ptr_;
  to.length_ = length_;
  to.alloc_ = alloc_;
  ptr_ = 0;
  length_ = 0;
  alloc_ = 0;
}
