// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef GrowableVectorD_INCLUDED
#define GrowableVectorD_INCLUDED 1

#include "VectorBase.H"
#include <stddef.h>

template<class T>
class GrowableVectorD : public VectorBase<T> {
public:
  GrowableVectorD();
  ~GrowableVectorD();
  GrowableVectorD(size_t);
  GrowableVectorD(const GrowableVectorD<T> &); // not defined
  GrowableVectorD<T> &operator=(const GrowableVectorD<T> &); // not defined
  // increase length by 1, return reference to last
  T &grow();
  void setLength(size_t);
  void moveTo(GrowableVectorD<T> &to);
  void clear();
protected:
  size_t alloc_;		// allocated size
};

#ifdef DEFINE_TEMPLATES
#include "GrowableVectorD.C"
#endif

#endif /* not GrowableVectorD_INCLUDED */
