// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef IList_INCLUDED
#define IList_INCLUDED 1

#include "IListBase.H"

template<class T> class IListIter;

// This owns the objects that are put in it.

template<class T>
class IList : private IListBase {
public:
  IList() { }
  IList(T *p) : IListBase(p) { }
  IList(const IList<T> &);	// undefined
  IList<T> &operator=(const IList<T> &); // undefined
  ~IList() { clear(); }
  void append(T *p) { IListBase::append(p); }
  void insert(T *p) { IListBase::insert(p); }
  void remove(T *p) { IListBase::remove(p); }
  void exch(IList<T> &list) { IListBase::exch(list); }
  T *head() const { return (T *)IListBase::head(); }
  T *get() { return (T *)IListBase::get(); }
  void moveTo(IList<T> &to) {
    IListBase::exch(to);
    clear();
  }
  IListBase::clear;
  IListBase::empty;
friend class IListIter<T>;
};

#endif /* not IList_INCLUDED */
