// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef IListBase_INCLUDED
#define IListBase_INCLUDED 1

#include "Link.H"
#include "Boolean.H"

class IListBase {
public:
  IListBase();
  IListBase(Link *);
  void  append(Link *);
  void insert(Link *);
  Link *head() const;
  Boolean empty() const;
  Link *get();
  void remove(Link *);
  void exch(IListBase &);
  void clear();
private:
  Link *head_;
friend class IListIterBase;
};

inline
IListBase::IListBase() : head_(0)
{
}

inline
IListBase::IListBase(Link *head) : head_(head)
{
}

inline
void IListBase::insert(Link *p)
{
  p->next_ = head_;
  head_ = p;
}

inline
Link *IListBase::head() const
{
  return head_;
}

inline
Boolean IListBase::empty() const
{
  return head_ == 0;
}

inline
Link *IListBase::get()
{
  Link *tem = head_;
  head_ = head_->next_;
  return tem;
}

inline
void IListBase::exch(IListBase &list)
{
  Link *tem = head_;
  head_ = list.head_;
  list.head_ = tem;
}

#endif /* not IListBase_INCLUDED */
