// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef IListIterBase_INCLUDED
#define IListIterBase_INCLUDED 1

#include "Link.H"
#include "IListBase.H"

class IListIterBase {
public:
  IListIterBase(const IListBase &);
  int done();
  Link *cur();
  void next();
private:
  Link *p_;
};

inline
IListIterBase::IListIterBase(const IListBase &list) : p_(list.head_)
{
}

inline
int IListIterBase::done()
{
  return p_ == 0;
}

inline
Link *IListIterBase::cur()
{
  return p_;
}

inline
void IListIterBase::next()
{
  p_ = p_->next_;
}

#endif /* not IListIterBase_INCLUDED */
