// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef IQueue_INCLUDED
#define IQueue_INCLUDED 1

#include "Boolean.H"
#include "Link.H"

class IQueueBase {
public:
  IQueueBase() : last_(0) { }
  ~IQueueBase() { }
  Boolean empty() const { return last_ == 0; }
  Link *get() {
    Link *tem = last_->next_;
    if (tem == last_)
      last_ = 0;
    else
      last_->next_ = tem->next_;
    return tem;
  }
  void append(Link *p) {
    if (last_) {
      p->next_ = last_->next_;
      last_ = last_->next_ = p;
    }
    else
      last_ = p->next_ = p;
  }
private:
  Link *last_;

};

template<class T>
class IQueue : public IQueueBase {
public:
  IQueue() { }
  ~IQueue() { clear(); }
  void clear();
  T *get() { return (T *)IQueueBase::get(); }
  void append(T *p) { IQueueBase::append(p); }
  Boolean empty() const { return IQueueBase::empty(); }
};

#ifdef DEFINE_TEMPLATES
#include "IQueue.C"
#endif

#endif /* not IQueue_INCLUDED */
