// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef ISet_INCLUDED
#define ISet_INCLUDED


#include <stddef.h>
#include "GrowableVector.H"
#include "Boolean.H"

template<class T> class ISetIter;

template<class T>
struct ISetRange {
  T min;
  T max;
};
  
template<class T>
class ISet {
public:
  ISet();
  ISet(const T *, size_t);
  ~ISet();
  int contains(T) const;
  void remove(T);
  void add(T x) { addRange(x, x); }
  void addRange(T, T);
  void add(const ISet<T> &);
  void check();
  void operator+=(T x) { addRange(x, x); }
  void clear();
  Boolean isSingleton() const {
    return r_.length() == 1 && r_[0].min == r_[0].max;
  }
  Boolean isEmpty() const { return r_.length() == 0; }
friend class ISetIter<T>;
private:
  GrowableVector<ISetRange<T> > r_;
};

#ifdef DEFINE_TEMPLATES
#include "ISet.C"
#endif

#endif /* not ISet_INCLUDED */
