// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef ListIter_INCLUDED
#define ListIter_INCLUDED 1

#include "List.H"
#include "IListIter.H"

template<class T>
class ListIter {
public:
  ListIter(const List<T> &list) : iter_(list.list_) { }
  const T &cur() { return iter_.cur()->value; }
  int done() { return iter_.done(); }
  void next() { iter_.next(); }
private:
  IListIter<ListItem<T> > iter_;
};

#endif /* not ListIter_INCLUDED */
