// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Owner_INCLUDED
#define Owner_INCLUDED 1

// A pointer that owns the object pointed to.
// T must be of class type.
// This is coded so that T need not yet have been defined.

template<class T>
class Owner {
public:
  Owner() : p_(0) { }
  Owner(T *p) : p_(p) { }
  Owner(const Owner<T> &);	// undefined
  void operator=(const Owner<T> &o); // undefined
  ~Owner();
  void operator=(T *p) {
    if (p_) del();
    p_ = p;
  }
  T *pointer() const { return p_; }
  operator int() const { return p_ != 0; }
  // operator T *() const { return p_; }
  T *operator->() const { return p_; }
  T &operator*() const { return *p_; }
  void exch(Owner<T> &x) {
    T *tem = p_;
    p_ = x.p_;
    x.p_ = tem;
  }
  T *extract() {
    T *tem = p_;
    p_ = 0;
    return tem;
  }
  void moveTo(Owner<T> &to) {
    if (to.p_)
      to.del();
    to.p_ = p_;
    p_ = 0;
  }
  void destruct() { this->Owner<T>::~Owner(); }
  void clear() {
    if (p_) {
      del();
      p_ = 0;
    }
  }
private:
  void del();
  T *p_;
};

#ifdef DEFINE_TEMPLATES
#include "Owner.C"
#endif

#endif /* not Owner_INCLUDED */
