// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef OwnerTable_INCLUDED
#define OwnerTable_INCLUDED 1

#include "PointerTable.H"

template<class T, class K, class HF, class KF>
class OwnerTable : public PointerTable<T *, K, HF, KF> {
public:
  OwnerTable();
  ~OwnerTable();
  OwnerTable(const OwnerTable<T, K, HF, KF> &);
  OwnerTable<T, K, HF, KF> &operator=(const OwnerTable<T, K, HF, KF> &);
  void clear();
  void moveTo(OwnerTable<T, K, HF, KF> &);
};

template<class T, class K, class HF, class KF>
class OwnerTableIter : public PointerTableIter<T *, K, HF, KF> {
public:
  OwnerTableIter(const OwnerTable<T, K, HF, KF> &table)
    : PointerTableIter<T *, K, HF, KF>(table) { }
};

#ifdef DEFINE_TEMPLATES
#include "OwnerTable.C"
#endif

#endif /* not OwnerTable_INCLUDED */
