// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include <stdlib.h>
#include "setAll.H"

template<class P, class K, class HF, class KF>
PointerTable<P, K, HF, KF>::PointerTable()
: used_(0), usedLimit_(0)
{
}

template<class P, class K, class HF, class KF>
void PointerTable<P, K, HF, KF>::clear()
{
  vec_.clear();
  used_ = 0;
  usedLimit_ = 0;
}

template<class P, class K, class HF, class KF>
P PointerTable<P, K, HF, KF>::insert(P p)
{
  size_t h;
  if (vec_.length() == 0) {
    vec_.init(8);
    setAll(vec_.pointer(), vec_.length(), P(0));
    h = startIndex(KF::key(*p));
  }
  else {
    for (h = startIndex(KF::key(*p)); vec_[h] != 0 ; h = nextIndex(h))
      if (KF::key(*vec_[h]) == KF::key(*p))
	return vec_[h];
    if (used_ >= usedLimit_) {
      if (vec_.length() > size_t(-1)/2) {
	if (usedLimit_ == vec_.length() - 1)
	  abort();		// FIXME throw an exception
	else
	  usedLimit_ = vec_.length() - 1;
      }
      else {
	// rehash
	Vector<P> oldVec(vec_.length()*2);
	setAll(oldVec.pointer(), oldVec.length(), P(0));
	vec_.exch(oldVec);
	usedLimit_ = vec_.length() / 2;
	for (size_t i = 0; i < oldVec.length(); i++)
	  if (oldVec[i] != 0) {
	    for (size_t j = startIndex(KF::key(*oldVec[i]));
		 vec_[j] != 0;
		 j = nextIndex(j))
	      ;
	    vec_[j] = oldVec[i];
	  }
	for (h = startIndex(KF::key(*p)); vec_[h] != 0; h = nextIndex(h))
	  ;
      }
    }
  }
  used_++;
  vec_[h] = p;
  return 0;
}

template<class P, class K, class HF, class KF>
P PointerTable<P, K, HF, KF>::lookup(const K &k) const
{
  if (used_ > 0) {
    for (size_t i = startIndex(k); vec_[i] != 0; i = nextIndex(i))
      if (KF::key(*vec_[i]) == k)
	return vec_[i];
  }
  return 0;
}

template<class P, class K, class HF, class KF>
void PointerTable<P, K, HF, KF>::moveTo(PointerTable<P, K, HF, KF> &to)
{
  vec_.moveTo(to.vec_);
  to.used_ = used_;
  used_ = 0;
  to.usedLimit_ = usedLimit_;
  usedLimit_ = 0;
}


template<class P, class K, class HF, class KF>
PointerTableIter<P, K, HF, KF>::PointerTableIter(const PointerTable<P, K, HF, KF> &table)
: vecPtr_(&table.vec_), i_(0)
{
}

template<class P, class K, class HF, class KF>
P PointerTableIter<P, K, HF, KF>::next()
{
  for (; i_ < vecPtr_->length(); i_++)
    if ((*vecPtr_)[i_] != 0)
      return (*vecPtr_)[i_++];
  return 0;
}
