// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef PointerTable_INCLUDED
#define PointerTable_INCLUDED 1

#include "Vector.H"
#include <stddef.h>

template<class P, class K, class HF, class KF> class PointerTableIter;

template<class P, class K, class HF, class KF>
class PointerTable {
  void constraints() {
    P p(0);
    K key = KF::key(*p);
    unsigned long n = HF::hash(key);
    n = 0;			// prevent warning
  }
public:
  PointerTable();
  PointerTable(const PointerTable<P, K, HF, KF> &); // undefined
  void operator=(const PointerTable<P, K, HF, KF> &); // undefined
  P insert(P);
  P lookup(const K &) const;
  size_t count() const { return used_; }
  void clear();
  void moveTo(PointerTable<P, K, HF, KF> &);
protected:
  size_t used_;
  size_t usedLimit_;
  Vector<P> vec_;

  size_t startIndex(const K &k) const {
    return size_t(HF::hash(k) & (vec_.length() - 1));
  }
  size_t nextIndex(size_t i) const {
    return i == 0 ? vec_.length() - 1 : i - 1;
  }
  friend class PointerTableIter<P, K, HF, KF>;
};

template<class P, class K, class HF, class KF>
class PointerTableIter {
public:
  PointerTableIter(const PointerTable<P, K, HF, KF> &);
  P next();
private:
  const Vector<P> *vecPtr_;
  size_t i_;
};

#ifdef DEFINE_TEMPLATES
#include "PointerTable.C"
#endif

#endif /* not PointerTable_INCLUDED */
