// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

template<class T>
ConstResourcePointer<T>::ConstResourcePointer(T *ptr) : ptr_(ptr)
{
  if (ptr_)
    ptr_->ref();
}

template<class T>
ConstResourcePointer<T>::~ConstResourcePointer()
{
  if (ptr_) {
    if (ptr_->unref())
      delete ptr_;
    ptr_ = 0;
  }
}

template<class T>
ConstResourcePointer<T>::ConstResourcePointer(const ConstResourcePointer<T> &p)
: ptr_(p.ptr_)
{
  if (p.ptr_)
    p.ptr_->ref();
}

template<class T>
ConstResourcePointer<T> &
ConstResourcePointer<T>::operator=(const ConstResourcePointer<T> &p)
{
  if (p.ptr_)
    p.ptr_->ref();
  if (ptr_ && ptr_->unref())
    delete ptr_;
  ptr_ = p.ptr_;
  return *this;
}

template<class T>
void ConstResourcePointer<T>::clear()
{
  if (ptr_) {
    if (ptr_->unref())
      delete ptr_;
    ptr_ = 0;
  }
}

template<class T>
void ConstResourcePointer<T>::moveTo(ConstResourcePointer<T> &to)
{
  if (this != &to) {
    if (to.ptr_ && to.ptr_->unref())
      delete to.ptr_;
    to.ptr_ = ptr_;
    ptr_ = 0;
  }
}
