// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef ResourcePointer_INCLUDED
#define ResourcePointer_INCLUDED 1

#include "Boolean.H"

template<class T> class ResourcePointer;

// T must have Resource as a public base class
// T may be an incomplete type

template<class T>
class ConstResourcePointer {
public:
  ConstResourcePointer() : ptr_(0) { }
  ConstResourcePointer(T *ptr);
  ~ConstResourcePointer();
  ConstResourcePointer(const ConstResourcePointer<T> &);
  ConstResourcePointer<T> &operator=(const ConstResourcePointer<T> &);
  const T *pointer() const { return ptr_; }
  const T *operator->() const { return ptr_; }
  const T &operator*() const { return *ptr_; }
  void moveTo(ConstResourcePointer<T> &p);
  Boolean isNull() const { return ptr_ == 0; }
  // operator const void *() const { return ptr_; }
  void clear();
  Boolean operator==(const ConstResourcePointer<T> &p) const {
    return ptr_ == p.ptr_;
  }
  Boolean operator!=(const ConstResourcePointer<T> &p) const {
    return ptr_ != p.ptr_;
  }
  Boolean operator==(const T *p) const {
    return ptr_ == p;
  }
  Boolean operator!=(const T *p) const {
    return ptr_ != p;
  }
  void destruct() { this->ConstResourcePointer<T>::~ConstResourcePointer(); }
private:
  T *ptr_;
friend class ResourcePointer<T>;
};

template<class T>
class ResourcePointer : public ConstResourcePointer<T> {
public:
  ResourcePointer() { }
  ResourcePointer(T *ptr) : ConstResourcePointer<T>(ptr) { }
  ~ResourcePointer() { }
  T *pointer() const { return ptr_; }
  T *operator->() const { return ptr_; }
  T &operator*() const { return *ptr_; }
  void exch(ResourcePointer<T> &p) {
    T *tem = p.ptr_;
    p.ptr_ = ptr_;
    ptr_ = tem;
  }
};

#ifdef DEFINE_TEMPLATES
#include "ResourcePointer.C"
#endif

#endif /* not ResourcePointer_INCLUDED */
