// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef String_INCLUDED
#define String_INCLUDED 1

#include <stddef.h>
#include <string.h>
#include "Boolean.H"

template<class T>
class String {
public:
  String();
  ~String() { if (ptr_) delete [] ptr_; }
  String(const T *, size_t);
  String(const String<T> &);
  String<T> &operator=(const String<T> &);
  size_t length() const { return length_; }
  void set(const T *, size_t);
  void clear();
  void init(size_t);
  void insert(size_t i, const String<T> &s);
  void moveTo(String<T> &str);
  const T &operator[](size_t i) const { return ptr_[i]; }
  T &operator[](size_t i) { return ptr_[i]; }
  T *pointer() { return ptr_; }
  const T *pointer() const { return ptr_; }
  String<T> &operator+=(T c) {
    if (length_ >= alloc_)
      grow(1);
    ptr_[length_++] = c;
    return *this;
  }
  String<T> &operator+=(const String<T> &s) {
    append(s.ptr_, s.length_);
    return *this;
  }
  void append(const T *, size_t);
  Boolean operator==(const String<T> &s) const {
    return (length_ == s.length_
	    && (length_ == 0
		|| (*ptr_ == *s.ptr_
		    && (memcmp(ptr_ + 1, s.ptr_ + 1, (length_ - 1)*sizeof(T))
			== 0))));
  }
  Boolean operator!=(const String<T> &str) const {
    return !(*this == str);
  }
  void setLength(size_t n);
  void destruct() { this->String<T>::~String(); }
private:
  void grow(size_t);
  T *ptr_;
  size_t length_;
  size_t alloc_;
};

#ifdef DEFINE_TEMPLATES
#include "String.C"
#endif

#endif /* not String_INCLUDED */
