// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include "SubstTable.H"

template<class T>
SubstTable<T>::SubstTable()
: pairsValid_(1)
{
}

template<class T>
void SubstTable<T>::addSubst(T from, T to)
{
  if (table_.length() == 0) {
    table_.init(T(-1) + 1);
    for (int i = 0; i < T(-1) + 1; i++)
      table_[i] = i;
  }
  if (table_[from] != to)
    pairsValid_ = 0;
  table_[from] = to;
}

template<class T>
String<T> SubstTable<T>::inverse(T ch) const
{
  if (!pairsValid_) {
    const T *p = table_.pointer();
    size_t length = table_.length();
    for (size_t i = 0; i < length; i++)
      if (p[i] != i) {
	// FIXME use mutable if available
	((SubstTable<T> *)this)->pairs_ += T(i);
	((SubstTable<T> *)this)->pairs_ += p[i];
      }
    ((SubstTable<T> *)this)->pairsValid_ = 1;
  }
  const T *p = pairs_.pointer();
  if (!p)
    return String<T>(&ch, 1);
  String<T> result;
  if (table_[ch] == ch)
    result += ch;
  for (size_t n = pairs_.length(); n > 0; n -= 2, p += 2)
    if (p[1] == ch)
      result += p[0];
  return result;
}
