// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef SubstTable_INCLUDED
#define SubstTable_INCLUDED

#include <limits.h>
#include "String.H"
#include "Boolean.H"

template<class T>
class SubstTable {
public:
  SubstTable();
  void addSubst(T from, T to);
  void subst(T &c) const { if (table_.length() > 0) c = table_[c]; }
  T operator[](T c) const { return table_.length() > 0 ? table_[c] : c; }
  String<T> inverse(T) const;
private:
  String<T> table_;
  String<T> pairs_;		// mutable
  Boolean pairsValid_;		// mutable
};

#if 0
class SubstTable<unsigned char> {
public:
  SubstTable();
  void addSubst(unsigned char from, unsigned char to) { table_[from] = to; }
  void subst(unsigned char &c) const { c = table_[c]; }
  unsigned char operator[](unsigned char c) const { return table_[c]; }
  String<unsigned char> inverse(unsigned char) const;
private:
  unsigned char table_[UCHAR_MAX + 1];
};
#endif

#ifdef DEFINE_TEMPLATES
#include "SubstTable.C"
#endif

#endif /* SubstTable_INCLUDED */
