// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include <stddef.h>

template<class T>
Vector<T>::Vector()
{
}

template<class T>
Vector<T>::Vector(size_t length)
: VectorBase<T>(length > 0 ? new T[length] : 0, length)
{
}

template<class T>
Vector<T>::~Vector()
{
  if (ptr_)
    delete [] ptr_;
}

template<class T>
void Vector<T>::init(size_t length)
{
  if (ptr_)
    delete [] ptr_;
  ptr_ = new T[length_ = length];
}

template<class T>
void Vector<T>::exch(Vector<T> &v)
{
  T *ptr = ptr_;
  size_t length = length_;
  ptr_ = v.ptr_;
  length_ = v.length_;
  v.ptr_ = ptr;
  v.length_ = length;
}

template<class T>
void Vector<T>::moveTo(Vector<T> &to)
{
  if (to.ptr_)
    delete [] to.ptr_;
  to.ptr_ = ptr_;
  ptr_ = 0;
  to.length_ = length_;
  length_ = 0;
}

template<class T>
void Vector<T>::clear()
{
  if (ptr_ != 0) {
    delete [] ptr_;
    ptr_ = 0;
  }
  length_ = 0;
}
