// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Vector_INCLUDED
#define Vector_INCLUDED 1

#include <stddef.h>
#include "VectorBase.H"

template<class T>
class Vector : public VectorBase<T> {
public:
  Vector();
  Vector(size_t);
  ~Vector();
  Vector(const Vector<T> &);	// not defined
  Vector<T> &operator=(const Vector<T> &); // not defined
  void exch(Vector<T> &v);
  void moveTo(Vector<T> &to);
  void clear();
  void init(size_t);
  void destruct() { this->Vector<T>::~Vector(); }
};

#ifdef DEFINE_TEMPLATES
#include "Vector.C"
#endif

#endif /* Vector_INCLUDED */
