// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef VectorBase_INCLUDED
#define VectorBase_INCLUDED 1

#include <stddef.h>

template<class T> class GrowableVectorD;
template<class T> class GrowableVector;
template<class T> class Vector;

template<class T>
class VectorBase {
public:
  size_t length() const { return length_; }
  T &operator[](size_t i) { return ptr_[i]; }
  const T &operator[](size_t i) const { return ptr_[i]; }
  T *pointer() { return ptr_; }
  const T *pointer() const { return ptr_; }
  operator T *() { return ptr_; }
  operator const T *() const { return ptr_; }
  T &last() { return ptr_[length_ - 1]; }
  const T &last() const { return ptr_[length_ - 1]; }
protected:
  VectorBase() : ptr_(0), length_(0) { }
  VectorBase(T *ptr, size_t length) : ptr_(ptr), length_(length) { }
  VectorBase(const VectorBase<T> &); // not defined
  VectorBase<T> &operator=(const VectorBase<T> &); // not defined

  size_t length_;
  T *ptr_;
};

#endif /* not VectorBase_INCLUDED */
