// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef macros_INCLUDED
#define macros_INCLUDED 1

#ifndef __GNUG__
#define __attribute__(args) /* as nothing */
#endif

#ifdef NDEBUG
#define ASSERT(expr) ((void)0)
#else
extern void assertionFailed(const char *, const char *, int)
     __attribute__((noreturn));

#define ASSERT(expr) \
  ((void)((expr) || (assertionFailed(# expr, __FILE__, __LINE__), 0)))
#endif

#define CANNOT_HAPPEN() ASSERT(0)

#define SIZEOF(v) (sizeof(v)/sizeof(v[0]))

#endif /* not macros_INCLUDED */
