// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef rtti_INCLUDED
#define rtti_INCLUDED 1

#include "TypeId.H"

#define RTTI_CLASS \
public: \
  virtual TypeId dynamicType() const; \
  static inline TypeId staticType() { return TypeId(RTTI_bases_); } \
protected: \
  static const void *RTTI_bases_[]; \
private:

#define RTTI_DEF0(T) \
  const void *T::RTTI_bases_[] = { 0 }; \
  TypeId T::dynamicType() const { return staticType(); }

#define RTTI_DEF1(T, B1) \
  const void *T::RTTI_bases_[] = { B1::RTTI_bases_, 0 }; \
  TypeId T::dynamicType() const { return staticType(); }

#define RTTI_DEF2(T, B1, B2) \
  const void *T::RTTI_bases_[] = { B1::RTTI_bases_, B2::RTTI_bases_, 0 }; \
  TypeId T::dynamicType() const { return staticType(); }

#define RTTI_DEF3(T, B1, B2, B3) \
  const void *T::RTTI_bases_[] = { \
    B1::RTTI_bases_, B2::RTTI_bases_, B3::RTTI_bases_, 0 }; \
  TypeId T::dynamicType() const { return staticType(); }

#define ptr_cast(T, p) \
((p) && (p)->dynamicType().canCast(T::staticType(), (p)->staticType()) \
 ? (T *)(p) \
 : 0)

#endif /* not rtti_INCLUDED */
