// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef SgmlsEventHandler_INCLUDED
#define SgmlsEventHandler_INCLUDED 1

#include <stddef.h>
#include "Event.H"
#include "Boolean.H"
#include "CString.H"
#include "OutputCharStream.H"
#include "StringSet.H"
#include "Location.H"
#include "Syntax.H"
#include "Sd.H"
#include "ResourcePointer.H"
#include "LinkProcess.H"
#include "InputContext.H"

class SgmlParser;
class Portable;
class StorageObjectSpec;
class MessageReporter;

class SgmlsSubdocState {
public:
  SgmlsSubdocState();
  SgmlsSubdocState(const SgmlParser *);
  void init(const SgmlParser *);
  void moveTo(SgmlsSubdocState &);
protected:
  const SgmlParser *parser_;
  StringSet definedEntities_;
  StringSet definedNotations_;
  Boolean haveLinkProcess_;
  LinkProcess linkProcess_;
private:
  SgmlsSubdocState(const SgmlsSubdocState &); // undefined
  void operator=(const SgmlsSubdocState &);   // undefined
};

class SgmlsEventHandler : public EventHandler, private SgmlsSubdocState,
                          private InputContext {
public:
  SgmlsEventHandler(const SgmlParser *,
		    Portable *,
		    OutputCharStream *,
		    MessageReporter *,
		    Boolean outputLocations);
  void data(DataEvent *);
  void startElement(StartElementEvent *);
  void endElement(EndElementEvent *);
  void pi(PiEvent *);
  void sdataEntity(SdataEntityEvent *);
  void externalDataEntity(ExternalDataEntityEvent *);
  void subdocEntity(SubdocEntityEvent *);
  void appinfo(AppinfoEvent *);
  void simpleLink(SimpleLinkEvent *);
  void complexLink(ComplexLinkEvent *);
  void uselink(UselinkEvent *);
  void sgmlDecl(SgmlDeclEvent *);
  void message(MessageEvent *);
  unsigned errorCount() const;
  void endDocument();
protected:
  void inputContextMessage(const char *source,
			   const Location &loc,
			   unsigned flags, int number,
			   const MessageArg **args,
			   int nArgs);
private:
  SgmlsEventHandler(const SgmlsEventHandler &); // undefined
  void operator=(const SgmlsEventHandler &);	// undefined

  void attributes(const AttributeList &attributes, char code,
		  const CString *ownerName);
  void startAttribute(const CString &name, char code,
		      const CString *ownerName);
  void defineEntity(const Entity *entity);
  void defineExternalDataEntity(const ExternalDataEntity *entity);
  void defineSubdocEntity(const SubdocEntity *entity);
  void defineInternalEntity(const InternalEntity *entity);
  void defineNotation(const Notation *notation);
  void externalId(const ExternalId &id);
  void externalEntityFilenames(const ExternalEntity *);
  Boolean markEntity(const Entity *);
  Boolean markNotation(const Notation *);
  void startData();
  void flushData();

  void outputLocation(const Location &loc);
  void outputLocation1(const Location &loc);
  void outputString(const CString &str);
  void outputString(const Char *, size_t);

  OutputCharStream &os();

  Portable *portable_;
  MessageReporter *reporter_;
  OutputCharStream *os_;
  Boolean haveData_;
  ConstResourcePointer<Sd> sd_;
  ConstResourcePointer<Syntax> syntax_;
  Boolean outputLocations_;
  const StorageObjectSpec *lastSos_;
  unsigned long lastLineno_;
  unsigned errorCount_;
};

inline
void SgmlsEventHandler::outputString(const CString &str)
{
  outputString(str.pointer(), str.length());
}

inline
OutputCharStream &SgmlsEventHandler::os()
{
  return *os_;
}

inline
unsigned SgmlsEventHandler::errorCount() const
{
  return errorCount_;
}

#endif /* not SgmlsEventHandler_INCLUDED */
