// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef StringSet_INCLUDED
#define StringSet_INCLUDED 1

#include "CString.H"
#include "Hash.H"
#include "Boolean.H"
#include "OwnerTable.H"

class StringSetKey {
public:
  static inline const CString &key(const CString &str) { return str; }
};

class StringSet {
public:
  StringSet();
  Boolean add(const CString &);	// return 1 if already there
  void moveTo(StringSet &);
  void clear();
private:
  StringSet(const StringSet &);	// undefined
  void operator=(const StringSet &); // undefined
  OwnerTable<CString, CString, Hash, StringSetKey> table_;
};

inline
void StringSet::clear()
{
  table_.clear();
}

#endif /* not StringSet_INCLUDED */
