// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Attributed_INCLUDED
#define Attributed_INCLUDED 1

#include "ResourcePointer.H"
#include "Attribute.H"

// This is used for things that have attribute definitions
// that notations and elements.

class Attributed {
public:
  Attributed() { }
  ConstResourcePointer<AttributeDefinitionList> attributeDef() const;
  void setAttributeDef(const ConstResourcePointer<AttributeDefinitionList> &);
private:
  ConstResourcePointer<AttributeDefinitionList> attributeDef_;

};

inline
ConstResourcePointer<AttributeDefinitionList> Attributed::attributeDef() const
{
  return attributeDef_;
}

inline
void Attributed::setAttributeDef(const ConstResourcePointer<AttributeDefinitionList> &def)
{
  attributeDef_ = def;
}

#endif /* not Attributed_INCLUDED */
