// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef CharsetDecl_INCLUDED
#define CharsetDecl_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "types.H"
#include "GrowableVectorD.H"
#include "ExternalId.H"
#include "ISet.H"
#include "Boolean.H"

class CharsetDeclRange {
public:
  enum Type {
    number,
    string,
    unused
    };
  CharsetDeclRange();
  CharsetDeclRange(WideChar, Number, WideChar);
  CharsetDeclRange(WideChar, Number);
  CharsetDeclRange(WideChar, Number, const CString &);
  void moveTo(CharsetDeclRange &to);
  void destruct() { this->CharsetDeclRange::~CharsetDeclRange(); }
  void rangeDeclared(WideChar min, Number count,
		     ISet<WideChar> &declared) const;
  void declaredSet(ISet<WideChar> &) const;
  void usedSet(ISet<Char> &) const;
  Boolean getCharInfo(WideChar fromChar,
		      CharsetDeclRange::Type &type,
		      Number &n,
		      CString &str) const;
  void stringToChar(const CString &str, ISet<WideChar> &to) const;
  void numberToChar(Number n, ISet<WideChar> &to) const;
private:
  WideChar descMin_;
  Number count_;
  WideChar baseMin_;
  Type type_;
  CString str_;
};

class CharsetDeclSection {
public:
  CharsetDeclSection();
  CharsetDeclSection(PublicId &);
  void addRange(CharsetDeclRange &);
  void moveTo(CharsetDeclSection &);
  void destruct() { this->CharsetDeclSection::~CharsetDeclSection(); }
  void rangeDeclared(WideChar min, Number count,
		     ISet<WideChar> &declared) const;
  void declaredSet(ISet<WideChar> &) const;
  void usedSet(ISet<Char> &) const;
  Boolean getCharInfo(WideChar fromChar,
		      const PublicId *&id,
		      CharsetDeclRange::Type &type,
		      Number &n,
		      CString &str) const;
  void stringToChar(const CString &str, ISet<WideChar> &to) const;
  void numberToChar(const PublicId *id, Number n, ISet<WideChar> &to) const;
private:
  CharsetDeclSection(const CharsetDeclSection &); // undefined
  void operator=(const CharsetDeclSection &);	  // undefined
  PublicId baseset_;
  GrowableVectorD<CharsetDeclRange> ranges_;
};

class CharsetDecl {
public:
  CharsetDecl();
  void addSection(PublicId &);
  void moveTo(CharsetDecl &);
  void clear();
  void declaredSet(ISet<WideChar> &) const;
  void usedSet(ISet<Char> &) const;
  void rangeDeclared(WideChar min, Number count,
		     ISet<WideChar> &declared) const;
  void addRange(WideChar, Number, WideChar);
  void addRange(WideChar, Number);
  void addRange(WideChar, Number, const CString &);
  Boolean getCharInfo(WideChar fromChar,
		      const PublicId *&id,
		      CharsetDeclRange::Type &type,
		      Number &n,
		      CString &str) const;
  void stringToChar(const CString &str, ISet<WideChar> &to) const;
  void numberToChar(const PublicId *id, Number n, ISet<WideChar> &to) const;
private:
  CharsetDecl(const CharsetDecl &); // undefined
  void operator=(const CharsetDecl &); // undefined
  GrowableVectorD<CharsetDeclSection> sections_;
};

#endif /* not CharsetDecl_INCLUDED */
