// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif
#include "CharsetRegistry.H"
#include "ExternalId.H"
#include "CharsetInfo.H"
#include "UnivCharsetDesc.H"
#include "CString.H"
#include "types.H"
#include "macros.H"

static UnivCharsetDesc::Range iso646_irv[] = {
  { 0, 128, 0 }
};

#if 0

// we'll throw in SPACE and DEL for free
static UnivCharsetDesc::Range iso646_irv_G0[] = {
 { 32, 96, 32 }
};

static UnivCharsetDesc::Range latin1_G1[] = {
 { 32, 96, 160 }		// should the first number be 160?
};

static UnivCharsetDesc::Range iso646_C0[] = {
  { 0, 32, 0 },
  { 127, 1, 127 },
};

static UnivCharsetDesc::Range iso6429_C1[] = {
  { 0, 32, 128 },
};

static UnivCharsetDesc::Range iso10646_ucs2[] = {
  { 32, 95, 32 },
  { 160, 0x10000 - 160, 160 },
};

static UnivCharsetDesc::Range iso10646_ucs4[] = {
  { 32, 95, 32 },
  { 160, 0x10000 - 160, 160 },
  { 0x10000, 0x80000000 - 0x10000, 0x10000 }
};

#else

// This is less strict.

static UnivCharsetDesc::Range iso646_irv_G0[] = {
 { 0, 128, 0 }
};

static UnivCharsetDesc::Range iso646_jp_G0[] = {
  { 0, 92, 0 },
  { 92, 1, 165 },		// backslash -> yen sign
  { 93, 33, 93 },
  { 126, 1, 0x203e },		// tilde -> overline
  { 127, 1, 127 },
};

static UnivCharsetDesc::Range latin1_G1[] = {
 { 0, 128, 128 }		// should the first number be 128?
};

static UnivCharsetDesc::Range iso646_C0[] = {
  { 0, 32, 0 },
  { 127, 1, 127 },
};

static UnivCharsetDesc::Range iso6429_C1[] = {
  { 0, 32, 128 },
};

static UnivCharsetDesc::Range iso10646_ucs2[] = {
  { 0, 0x10000, 0 },
};

static UnivCharsetDesc::Range iso10646_ucs4[] = {
  { 0, 0x80000000, 0 },
};

#endif

static struct {
  const char *sequence;
  const UnivCharsetDesc::Range *ranges;
  size_t nRanges;
} table[] = {
  { "ESC 2/5 4/0", iso646_irv, SIZEOF(iso646_irv) },
  { "ESC 2/8 4/0", iso646_irv_G0, SIZEOF(iso646_irv_G0) },
  { "ESC 2/8 4/10", iso646_jp_G0, SIZEOF(iso646_jp_G0) },
  { "ESC 2/8 4/2", iso646_irv_G0, SIZEOF(iso646_irv_G0) }, // ASCII
  { "ESC 2/13 4/1", latin1_G1, SIZEOF(latin1_G1) },
  { "ESC 2/1 4/0", iso646_C0, SIZEOF(iso646_C0) },
  { "ESC 2/2 4/3", iso6429_C1, SIZEOF(iso6429_C1) },
  { "ESC 2/5 2/15 4/0", iso10646_ucs2, SIZEOF(iso10646_ucs2) },
  { "ESC 2/5 2/15 4/3", iso10646_ucs2, SIZEOF(iso10646_ucs2) },
  { "ESC 2/5 2/15 4/5", iso10646_ucs2, SIZEOF(iso10646_ucs2) },
  { "ESC 2/5 2/15 4/1", iso10646_ucs4, SIZEOF(iso10646_ucs4) },
  { "ESC 2/5 2/15 4/4", iso10646_ucs4, SIZEOF(iso10646_ucs4) },
  { "ESC 2/5 2/15 4/6", iso10646_ucs4, SIZEOF(iso10646_ucs4) },
};

Boolean CharsetRegistry::findCharset(const PublicId &id,
				     const CharsetInfo &charset,
				     UnivCharsetDesc &desc)
{
  PublicId::OwnerType ownerType;
  if (!id.getOwnerType(ownerType) || ownerType != PublicId::ISO)
    return 0;
  CString sequence;
  if (!id.getDesignatingSequence(sequence))
    return 0;
  // Canonicalize the escape sequence by mapping esc -> ESC,
  // removing leading zeros from escape sequences, and removing
  // initial spaces.
  CString s;
  for (int i = 0; i < sequence.length(); i++) {
    Char c = sequence[i];
    if (c == charset.execToDesc('e'))
      s += charset.execToDesc('E');
    else if (c == charset.execToDesc('s'))
      s += charset.execToDesc('S');
    else if (c == charset.execToDesc('c'))
      s += charset.execToDesc('C');
    else if (charset.digitWeight(c) >= 0
	     && s.length() > 0
	     && s[s.length() - 1] == charset.execToDesc('0')
	     && (s.length() == 1
		 || charset.digitWeight(s[s.length() - 2]) >= 0))
      s[s.length() - 1] = c;
    else if (c != charset.execToDesc(' ') || s.length() > 0)
      s += c;
  }
  for (i = 0; i < SIZEOF(table); i++)
    if (s == charset.execToDesc(table[i].sequence)) {
      desc.set(table[i].ranges, table[i].nRanges);
      return 1;
    }
  return 0;
}

Boolean CharsetRegistry::findNamedChar(const CString &str,
				       const CharsetInfo &charset,
				       UnivChar &c)
{
  static struct {
    const char *name;
    UnivChar univChar;
  } table[] = {
    { "LS0 in ISO 2022", 15 },
    { "LS1 in ISO 2022", 14 },
    { "SS2 in ISO 2022", 142 },
    { "SS3 in ISO 2022", 143 }
  };
  for (int i = 0; i < SIZEOF(table); i++)
    if (str == charset.execToDesc(table[i].name)) {
      c = table[i].univChar;
      return 1;
    }
  return 0;
}
