// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif
#include "ElementType.H"
#include "ContentToken.H"
#include "macros.H"

ElementType::ElementType(const CString &name, size_t index)
: Named(name), index_(index), map_(0), defIndex_(0)
{
}

ElementDefinition::ElementDefinition(const Location &location,
				     size_t index,
				     unsigned char omitFlags,
				     DeclaredContent declaredContent)
: location_(location),
  index_(index),
  omitFlags_(omitFlags),
  declaredContent_(declaredContent)
{
  computeMode();
}

ElementDefinition::ElementDefinition(const Location &location,
				     size_t index,
				     unsigned char omitFlags,
				     DeclaredContent declaredContent,
				     Owner<CompiledModelGroup> &modelGroup)
: location_(location),
  index_(index),
  omitFlags_(omitFlags),
  declaredContent_(declaredContent),
  modelGroup_(modelGroup.extract())
{
  computeMode();
}

void ElementDefinition::computeMode()
{
  switch (declaredContent_) {
  case modelGroup:
    if (!modelGroup_->containsPcdata()) {
      netMode_ = econnetMode;
      mode_ = econMode;
      break;
    }
    // fall through
  case any:
    netMode_ = mconnetMode;
    mode_ = mconMode;
    break;
  case cdata:
    netMode_ = cconnetMode;
    mode_ = cconMode;
    break;
  case rcdata:
    netMode_ = rcconnetMode;
    mode_ = rcconMode;
    break;
  case empty:
    break;
  default:
    CANNOT_HAPPEN();
  }
}

void ElementType::moveTo(ElementType &to)
{
  Named::moveTo(to);
  to.index_ = index_;
  to.defIndex_ = defIndex_;
  def_.moveTo(to.def_);
  to.map_ = map_;
}

RankStem::RankStem(const CString &name, size_t index)
: Named(name), index_(index)
{
}

void RankStem::addDefinition(const ConstResourcePointer<ElementDefinition> &p)
{
  def_.grow() = p;
}

