// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef EntityManager_INCLUDED
#define EntityManager_INCLUDED 1

#include "SubstTable.H"
#include "CString.H"
#include "types.H"

class InputSource;
class EntityOrigin;
class InputContext;
class CharsetInfo;
class ExternalEntity;

class EntityManager {
public:
  virtual ~EntityManager() { }
  virtual InputSource *openExternal(const ExternalEntity &,
				    EntityOrigin *,
				    const CharsetInfo &,
				    const SubstTable<Char> *,
				    const CString &pero,
				    Boolean mayRewind,
				    InputContext &) = 0;
};

#endif /* not EntityManager_INCLUDED */
