// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif
#include "Event.H"
#include "Entity.H"
#include "Attribute.H"
#include "EventQueue.H"

Event::~Event()
{
}

void Event::copyData()
{
}

LocatedEvent::LocatedEvent(Type type, const Location &location)
: location_(location), Event(type)
{
}

ElementEvent::ElementEvent(Type type,
			   const ElementType *elementType,
			   const ConstResourcePointer<Dtd> &dtd,
			   const Location &startLocation,
			   Index nextIndex,
			   Minimization minimization,
			   CString &origName)
: elementType_(elementType),
  dtd_(dtd),
  nextIndex_(nextIndex),
  minimization_(minimization),
  included_(0),
  copied_(0),
  LocatedEvent(type, startLocation)
{
  origName.moveTo(origName_);
}

ElementEvent::ElementEvent(Type type,
			   const ElementType *elementType,
			   const ConstResourcePointer<Dtd> &dtd,
			   const Location &startLocation,
			   Index nextIndex,
			   Minimization minimization)
: elementType_(elementType),
  dtd_(dtd),
  nextIndex_(nextIndex),
  minimization_(minimization),
  included_(0),
  LocatedEvent(type, startLocation)
{
}


StartElementEvent::StartElementEvent(const ElementType *elementType,
				     const ConstResourcePointer<Dtd> &dtd,
				     const Location &startLocation,
				     Index nextIndex,
				     Minimization minimization,
				     AttributeList *attributes,
				     CString &origName)
: ElementEvent(startElement, elementType, dtd, startLocation, nextIndex,
	       minimization, origName),
  attributes_(attributes)
{
}


StartElementEvent::StartElementEvent(const ElementType *elementType,
				     const ConstResourcePointer<Dtd> &dtd,
				     const Location &startLocation,
				     Index nextIndex,
				     Minimization minimization,
				     AttributeList *attributes)
: ElementEvent(startElement, elementType, dtd, startLocation, nextIndex,
	       minimization),
  attributes_(attributes),
  copied_(0)
{
}

StartElementEvent::~StartElementEvent()
{
  if (copied_)
    delete attributes_;
}

void StartElementEvent::copyData()
{
  if (!copied_) {
    AttributeList *p = new AttributeList;
    attributes_->moveTo(*p);
    attributes_ = p;
    copied_ = 1;
  }
}

EndElementEvent::EndElementEvent(const ElementType *elementType,
				 const ConstResourcePointer<Dtd> &dtd,
				 const Location &startLocation,
				 Index nextIndex,
				 Minimization minimization,
				 CString &origName)
: ElementEvent(endElement, elementType, dtd, startLocation, nextIndex,
	       minimization, origName)
{
}


EndElementEvent::EndElementEvent(const ElementType *elementType,
				 const ConstResourcePointer<Dtd> &dtd,
				 const Location &startLocation,
				 Index nextIndex,
				 Minimization minimization)
: ElementEvent(endElement, elementType, dtd, startLocation, nextIndex,
	       minimization)
{
}

DataEvent::DataEvent(Type type, const Char *p, size_t length,
		     const Location &location)
: p_(p),length_(length), LocatedEvent(type, location)
{
}

ImmediateDataEvent::ImmediateDataEvent(Type type, const Char *p, size_t length,
				       const Location &location,
				       Boolean copy)
: DataEvent(type, p, length, location), alloc_(0)
{
  if (copy) 
    ImmediateDataEvent::copyData();
}

ImmediateDataEvent::~ImmediateDataEvent()
{
  if (alloc_)
    delete [] alloc_;
}

void ImmediateDataEvent::copyData()
{
  if (!alloc_) {
    alloc_ = new Char[length_];
    memcpy(alloc_, p_, length_*sizeof(Char));
    p_ = alloc_;
  }
}

IgnoredCharsEvent::IgnoredCharsEvent(const Char *p, size_t length,
				     const Location &location, Boolean copy)
: ImmediateDataEvent(ignoredChars, p, length, location, copy)
{
}

RsEvent::RsEvent(const Char *p, const Location &location, Boolean copy)
: IgnoredCharsEvent(p, 1, location, copy)
{
}

ReEvent::ReEvent(const Char *p, const Location &location, unsigned long serial)
: ImmediateDataEvent(characterData, p, 1, location, 0),
  serial_(serial)
{
}

IgnoredReEvent::IgnoredReEvent(const Char *p, const Location &location,
			       unsigned long serial)
: IgnoredCharsEvent(p, 1, location, 0),
  serial_(serial)
{
}

ReOriginEvent::ReOriginEvent(const Location &location, unsigned long serial)
: location_(location), serial_(serial), Event(reOrigin)
{
}


DataEntityEvent::DataEntityEvent(Type type, const InternalDataEntity *entity,
				 const ConstResourcePointer<Origin> &origin)
: DataEvent(type,
	    entity->string().pointer(),
	    entity->string().length(),
	    Location(origin, 0)),
  origin_(origin)
{
}

CdataEntityEvent::CdataEntityEvent(const InternalCdataEntity *entity,
				   const ConstResourcePointer<Origin> &origin)
: DataEntityEvent(characterData, entity, origin)
{
}

SdataEntityEvent::SdataEntityEvent(const InternalSdataEntity *entity,
				   const ConstResourcePointer<Origin> &origin)
: DataEntityEvent(sdataEntity, entity, origin)
{
}

MessageEvent::MessageEvent(Source source, Type type, const Location &location,
			   int number, Vector<Owner<MessageArg> > &args,
			   const Location &auxLoc)
: source_(source),
  type_(type),
  number_(number),
  auxLocation_(auxLoc),
  LocatedEvent(message, location)
{
  args.moveTo(args_);
}

void MessageEvent::setOpenElementInfo(Vector<OpenElementInfo> &v)
{
  v.moveTo(openElements_);
}

OpenElementInfo::OpenElementInfo()
: included(0), matchIndex(0)
{
}

PiEvent::PiEvent(const Char *data, size_t dataLength, const Location &location)
: data_(data), dataLength_(dataLength), LocatedEvent(pi, location)
{
}

PiEntityEvent::PiEntityEvent(const PiEntity *entity,
			     const ConstResourcePointer<Origin> &origin)
: PiEvent(entity->string().pointer(), entity->string().length(),
	  Location(origin, 0)),
  origin_(origin)
{
}


ImmediatePiEvent::ImmediatePiEvent(CString &str, const Location &loc)
: PiEvent(str.pointer(), str.length(), loc)
{
  str.moveTo(string_);
}

ExternalEntityEvent::ExternalEntityEvent(Type type, 
					 const ExternalNonTextEntity *entity,
					 const ResourcePointer<EntityOrigin> &origin)
: entity_(entity), origin_(origin), Event(type)
{
}

ExternalDataEntityEvent::ExternalDataEntityEvent(const ExternalDataEntity *entity,
						 const ResourcePointer<EntityOrigin> &origin)
: dataEntity_(entity), ExternalEntityEvent(externalDataEntity, entity, origin)
{
}

SubdocEntityEvent::SubdocEntityEvent(const SubdocEntity *entity,
				     const ResourcePointer<EntityOrigin> &origin)
: subdocEntity_(entity), ExternalEntityEvent(subdocEntity, entity, origin)
{
}



AppinfoEvent::AppinfoEvent(const Location &location)
: LocatedEvent(appinfo, location), appinfoNone_(1)
{
}

AppinfoEvent::AppinfoEvent(const Text &text, const Location &location)
: LocatedEvent(appinfo, location), appinfoNone_(0), appinfo_(text)
{
}

Boolean AppinfoEvent::literal(const CString *&p) const
{
  if (appinfoNone_)
    return 0;
  p = &appinfo_.string();
  return 1;
}

SimpleLinkEvent::SimpleLinkEvent(const CString &name,
				 AttributeList &attributes,
				 const Location &location)
: LocatedEvent(simpleLink, location), name_(name)
{
  attributes.moveTo(attributes_);
}

ComplexLinkEvent::ComplexLinkEvent(const ConstResourcePointer<ComplexLpd> &lpd,
				   const VectorBase<ConstResourcePointer<Lpd> > &activeLpds)
: Event(complexLink), lpd_(lpd)
{
  activeLpds_.init(activeLpds.length());
  for (size_t i = 0; i < activeLpds_.length(); i++)
    activeLpds_[i] = activeLpds[i];
}


UselinkEvent::UselinkEvent(const ConstResourcePointer<Lpd> &lpd,
			   const LinkSet *linkSet,
			   Boolean restore,
			   const Location &location)
: LocatedEvent(uselink, location),
  lpd_(lpd),
  linkSet_(linkSet),
  restore_(restore)
{
}

StartDtdEvent::StartDtdEvent(const CString &name, const Location &location)
: name_(name), LocatedEvent(startDtd, location)
{
}

EndDtdEvent::EndDtdEvent(const ConstResourcePointer<Dtd> &dtd,
			 const Location &location)
:  LocatedEvent(endDtd, location), dtd_(dtd)
{
}

EndPrologEvent::EndPrologEvent(const Location &location)
: LocatedEvent(endProlog, location)
{
}

SgmlDeclEvent::SgmlDeclEvent(const ConstResourcePointer<Sd> &sd,
			     const ConstResourcePointer<Syntax> &syntax)

: sd_(sd), prologSyntax_(syntax), instanceSyntax_(syntax),
  LocatedEvent(sgmlDecl, Location())
{
}

SgmlDeclEvent::SgmlDeclEvent(const ConstResourcePointer<Sd> &sd,
			     const ConstResourcePointer<Syntax> &prologSyntax,
			     const ConstResourcePointer<Syntax> &instanceSyntax,
			     const Location &startLocation,
			     Index nextIndex)
: sd_(sd), prologSyntax_(prologSyntax), instanceSyntax_(instanceSyntax),
  nextIndex_(nextIndex), LocatedEvent(sgmlDecl, startLocation)
{
}

ExternalEntityDeclEvent:: ExternalEntityDeclEvent(const ConstResourcePointer<Entity> &entity,
						  Boolean duplicate)
: Event(externalEntityDecl),
  entity_(entity),
  duplicate_(duplicate)
{
}

NotationDeclEvent:: NotationDeclEvent(const ConstResourcePointer<Notation> &notation)
: Event(notationDecl), notation_(notation)
{
}

void EventHandler::data(DataEvent *event)
{
  delete event;
}

void EventHandler::ignoredChars(IgnoredCharsEvent *event)
{
  delete event;
}

void EventHandler::startElement(StartElementEvent *event)
{
  delete event;
}

void EventHandler::endElement(EndElementEvent *event)
{
  delete event;
}

void EventHandler::pi(PiEvent *event)
{
  delete event;
}

void EventHandler::externalDataEntity(ExternalDataEntityEvent *event)
{
  delete event;
}

void EventHandler::subdocEntity(SubdocEntityEvent *event)
{
  delete event;
}

void EventHandler::sdataEntity(SdataEntityEvent *event)
{
  delete event;
}

void EventHandler::reOrigin(ReOriginEvent *event)
{
  delete event;
}

void EventHandler::appinfo(AppinfoEvent *event)
{
  delete event;
}

void EventHandler::simpleLink(SimpleLinkEvent *event)
{
  delete event;
}

void EventHandler::complexLink(ComplexLinkEvent *event)
{
  delete event;
}

void EventHandler::uselink(UselinkEvent *event)
{
  delete event;
}

void EventHandler::startDtd(StartDtdEvent *event)
{
  delete event;
}

void EventHandler::endDtd(EndDtdEvent *event)
{
  delete event;
}

void EventHandler::endProlog(EndPrologEvent *event)
{
  delete event;
}

void EventHandler::sgmlDecl(SgmlDeclEvent *event)
{
  delete event;
}

void EventHandler::externalEntityDecl(ExternalEntityDeclEvent *event)
{
  delete event;
}

void EventHandler::notationDecl(NotationDeclEvent *event)
{
  delete event;
}

EventQueue::EventQueue()
{
}

void EventQueue::message(MessageEvent *event)
{
  append(event);
}

void EventQueue::data(DataEvent *event)
{
  append(event);
}

void EventQueue::ignoredChars(IgnoredCharsEvent *event)
{
  append(event);
}

void EventQueue::startElement(StartElementEvent *event)
{
  append(event);
}

void EventQueue::endElement(EndElementEvent *event)
{
  append(event);
}

void EventQueue::pi(PiEvent *event)
{
  append(event);
}

void EventQueue::externalDataEntity(ExternalDataEntityEvent *event)
{
  append(event);
}

void EventQueue::subdocEntity(SubdocEntityEvent *event)
{
  append(event);
}

void EventQueue::sdataEntity(SdataEntityEvent *event)
{
  append(event);
}

void EventQueue::reOrigin(ReOriginEvent *event)
{
  append(event);
}

void EventQueue::appinfo(AppinfoEvent *event)
{
  append(event);
}

void EventQueue::simpleLink(SimpleLinkEvent *event)
{
  append(event);
}

void EventQueue::complexLink(ComplexLinkEvent *event)
{
  append(event);
}

void EventQueue::uselink(UselinkEvent *event)
{
  append(event);
}

void EventQueue::startDtd(StartDtdEvent *event)
{
  append(event);
}

void EventQueue::endDtd(EndDtdEvent *event)
{
  append(event);
}

void EventQueue::endProlog(EndPrologEvent *event)
{
  append(event);
}

void EventQueue::sgmlDecl(SgmlDeclEvent *event)
{
  append(event);
}

void EventQueue::externalEntityDecl(ExternalEntityDeclEvent *event)
{
  append(event);
}

void EventQueue::notationDecl(NotationDeclEvent *event)
{
  append(event);
}

void DataEvent::handle(EventHandler &handler)
{
  handler.data(this);
}

void SdataEntityEvent::handle(EventHandler &handler)
{
  handler.sdataEntity(this);
}

void IgnoredCharsEvent::handle(EventHandler &handler)
{
  handler.ignoredChars(this);
}

void ReOriginEvent::handle(EventHandler &handler)
{
  handler.reOrigin(this);
}

void StartElementEvent::handle(EventHandler &handler)
{
  handler.startElement(this);
}

void EndElementEvent::handle(EventHandler &handler)
{
  handler.endElement(this);
}

void ExternalDataEntityEvent::handle(EventHandler &handler)
{
  handler.externalDataEntity(this);
}

void SubdocEntityEvent::handle(EventHandler &handler)
{
  handler.subdocEntity(this);
}

void MessageEvent::handle(EventHandler &handler)
{
  handler.message(this);
}

void PiEvent::handle(EventHandler &handler)
{
  handler.pi(this);
}

void AppinfoEvent::handle(EventHandler &handler)
{
  handler.appinfo(this);
}

void SimpleLinkEvent::handle(EventHandler &handler)
{
  handler.simpleLink(this);
}

void ComplexLinkEvent::handle(EventHandler &handler)
{
  handler.complexLink(this);
}

void UselinkEvent::handle(EventHandler &handler)
{
  handler.uselink(this);
}

void StartDtdEvent::handle(EventHandler &handler)
{
  handler.startDtd(this);
}

void EndDtdEvent::handle(EventHandler &handler)
{
  handler.endDtd(this);
}

void EndPrologEvent::handle(EventHandler &handler)
{
  handler.endProlog(this);
}

void SgmlDeclEvent::handle(EventHandler &handler)
{
  handler.sgmlDecl(this);
}

void ExternalEntityDeclEvent::handle(EventHandler &handler)
{
  handler.externalEntityDecl(this);
}

void NotationDeclEvent::handle(EventHandler &handler)
{
  handler.notationDecl(this);
}

Pass1EventHandler::Pass1EventHandler()
: hadError_(0), origHandler_(0)
{
}

void Pass1EventHandler::init(EventHandler *origHandler)
{
  hadError_ = 0;
  origHandler_ = origHandler;
}

void Pass1EventHandler::message(MessageEvent *event)
{
  if (event->isError()) {
    hadError_ = 1;
    origHandler_->message(event);
  }
  else
    IQueue<Event>::append(event);
}
