// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef EventQueue_INCLUDED
#define EventQueue_INCLUDED 1

#include "IQueue.H"
#include "Event.H"

class EventQueue : public EventHandler, public IQueue<Event> {
public:
  EventQueue();
private:
  void message(MessageEvent *);
  void data(DataEvent *);
  void ignoredChars(IgnoredCharsEvent *);
  void startElement(StartElementEvent *);
  void endElement(EndElementEvent *);
  void pi(PiEvent *);
  void sdataEntity(SdataEntityEvent *);
  void externalDataEntity(ExternalDataEntityEvent *);
  void subdocEntity(SubdocEntityEvent *);
  void reOrigin(ReOriginEvent *);
  void appinfo(AppinfoEvent *);
  void simpleLink(SimpleLinkEvent *);
  void complexLink(ComplexLinkEvent *);
  void uselink(UselinkEvent *);
  void startDtd(StartDtdEvent *);
  void endDtd(EndDtdEvent *);
  void endProlog(EndPrologEvent *);
  void sgmlDecl(SgmlDeclEvent *);
  void externalEntityDecl(ExternalEntityDeclEvent *);
  void notationDecl(NotationDeclEvent *);
  void append(Event *);
};

class Pass1EventHandler : public EventQueue {
public:
  Pass1EventHandler();
  void init(EventHandler *origHandler);
  void message(MessageEvent *);
  Boolean hadError() const;
  EventHandler *origHandler() const;
private:
  Boolean hadError_;
  EventHandler *origHandler_;
};

inline
void EventQueue::append(Event *event)
{
  IQueue<Event>::append(event);
}

inline
Boolean Pass1EventHandler::hadError() const
{
  return hadError_;
}

inline
EventHandler *Pass1EventHandler::origHandler() const
{
  return origHandler_;
}

#endif /* not EventQueue_INCLUDED */
