// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef EventsWanted_INCLUDED
#define EventsWanted_INCLUDED 1

#include "Boolean.H"

class EventsWanted {
public:
  EventsWanted();
  Boolean wantEsisPlus() const;
  void addEsisPlus();
private:
  PackedBoolean esisPlus_;
};

inline
EventsWanted::EventsWanted()
: esisPlus_(0)
{
}

inline
Boolean EventsWanted::wantEsisPlus() const
{
  return esisPlus_;
}

inline
void EventsWanted::addEsisPlus()
{
  esisPlus_ = 1;
}

#endif /* not EventsWanted_INCLUDED */
