// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef ExternalId_INCLUDED
#define ExternalId_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "Boolean.H"
#include "CString.H"
#include "Text.H"
#include "types.H"

class CharsetInfo;

class PublicId {
public:
  enum TextClass {
    CAPACITY,
    CHARSET,
    DOCUMENT,
    DTD,
    ELEMENTS,
    ENTITIES,
    LPD,
    NONSGML,
    NOTATION,
    SHORTREF,
    SUBDOC,
    SYNTAX,
    TEXT
  };
  enum OwnerType {
    ISO,
    registered,
    unregistered
    };
  enum FormalError {
    missingField,
    missingTextClassSpace,
    invalidTextClass,
    invalidLanguage,
    illegalDisplayVersion,
    extraField
  };
  PublicId();

  Boolean getOwnerType(OwnerType &) const;
  Boolean getOwner(CString &) const;
  Boolean getTextClass(TextClass &) const;
  Boolean getUnavailable(Boolean &) const;
  Boolean getDescription(CString &) const;
  Boolean getLanguage(CString &) const;
  Boolean getDesignatingSequence(CString &) const;
  Boolean getDisplayVersion(CString &) const;
  // If it's not a valid formal public identifier, return 0
  // and set error, otherwise return 1.
  // charset describes the character set to use for parsing the
  // id.
  Boolean init(Text &, const CharsetInfo &, Char space, FormalError &error);
  void moveTo(PublicId &);
  const CString &string() const;
private:
  static Boolean nextField(Char solidus,
			   const Char *&next,
			   const Char *lim,
			   const Char *&fieldStart,
			   size_t &fieldLength);
  static Boolean lookupTextClass(const CString &, const CharsetInfo &,
				 TextClass &);
  static const char *const textClasses[];

  PackedBoolean formal_;
  OwnerType ownerType_;
  CString owner_;
  TextClass textClass_;
  PackedBoolean unavailable_;
  CString description_;
  CString languageOrDesignatingSequence_;
  PackedBoolean haveDisplayVersion_;
  CString displayVersion_;
  Text text_;
};

class ExternalId {
public:
  ExternalId();
  const CString *systemIdString() const;
  const CString *publicIdString() const;
  const PublicId *publicId() const;
  void setSystem(Text &);
  // If it's not a valid formal public identifier, return 0
  // and set error, otherwise return 1.
  // charset describes the character set to use for parsing the
  // id.
  Boolean setPublic(Text &, const CharsetInfo &, Char space,
		    PublicId::FormalError &error);
  void moveTo(ExternalId &);
private:
  PackedBoolean haveSystem_;
  PackedBoolean havePublic_;
  Text system_;
  PublicId public_;
};

inline
const CString &PublicId::string() const
{
  return text_.string();
}

inline
const CString *ExternalId::systemIdString() const
{
  return haveSystem_ ? &system_.string() : 0;
}

inline
const CString *ExternalId::publicIdString() const
{
  return havePublic_ ? &public_.string() : 0;
}

inline
const PublicId *ExternalId::publicId() const
{
  return havePublic_ ? &public_ : 0;
}

#endif /* not ExternalId_INCLUDED */
