// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif
#include "Group.H"
#include "MessageBuilder.H"
#include "Fragments.H"
#include "macros.H"

AllowedGroupTokens::AllowedGroupTokens(GroupToken::Type t1, GroupToken::Type t2,
				       GroupToken::Type t3, GroupToken::Type t4)
: flags_(0)
{
  allow(t1);
  allow(t2);
  allow(t3);
  allow(t4);
}

AllowedGroupConnectors::AllowedGroupConnectors(GroupConnector::Type c1)
: flags_(0)
{
  allow(c1);
}

AllowedGroupConnectors::AllowedGroupConnectors(GroupConnector::Type c1,
					       GroupConnector::Type c2)
: flags_(0)
{
  allow(c1);
  allow(c2);
}

AllowedGroupConnectors::AllowedGroupConnectors(GroupConnector::Type c1,
					       GroupConnector::Type c2,
					       GroupConnector::Type c3)
: flags_(0)
{
  allow(c1);
  allow(c2);
  allow(c3);
}

AllowedGroupConnectors::AllowedGroupConnectors(GroupConnector::Type c1,
					       GroupConnector::Type c2,
					       GroupConnector::Type c3,
					       GroupConnector::Type c4)
: flags_(0)
{
  allow(c1);
  allow(c2);
  allow(c3);
  allow(c4);
}


AllowedGroupConnectorsMessageArg::AllowedGroupConnectorsMessageArg(
  const AllowedGroupConnectors &allow,
  const ConstResourcePointer<Syntax> &syntax)
: allow_(allow),
  syntax_(syntax)
{
}

MessageArg *AllowedGroupConnectorsMessageArg::copy() const
{
  return new AllowedGroupConnectorsMessageArg(*this);
}

void AllowedGroupConnectorsMessageArg::append(MessageBuilder &builder) const
{
  static GroupConnector::Type types[] = {
    GroupConnector::and, GroupConnector::or, GroupConnector::seq,
    GroupConnector::grpc, GroupConnector::dtgc
    };
  static Syntax::DelimGeneral delims[] = {
    Syntax::dAND, Syntax::dOR, Syntax::dSEQ,
    Syntax::dGRPC, Syntax::dDTGC
    };
  Boolean first = 1;
  for (int i = 0; i < SIZEOF(types); i++)
    if (allow_.groupConnector(types[i])) {
      if (!first)
	builder.appendFragment(Fragments::listSep);
      else
	first = 0;
      const CString &delim(syntax_->delimGeneral(delims[i]));
      builder.appendFragment(Fragments::delimStart);
      builder.appendChars(delim.pointer(), delim.length());
      builder.appendFragment(Fragments::delimEnd);
    }
}

AllowedGroupTokensMessageArg::AllowedGroupTokensMessageArg(
  const AllowedGroupTokens &allow,
  const ConstResourcePointer<Syntax> &syntax)
: allow_(allow),
  syntax_(syntax)
{
}

MessageArg *AllowedGroupTokensMessageArg::copy() const
{
  return new AllowedGroupTokensMessageArg(*this);
}

void AllowedGroupTokensMessageArg::append(MessageBuilder &builder) const
{
  int fragment[4];
  int nFragments = 0;
  if (allow_.groupToken(GroupToken::dataTagLiteral))
    fragment[nFragments++] = Fragments::parameterLiteral;
  if (allow_.groupToken(GroupToken::dataTagGroup))
    fragment[nFragments++] = Fragments::dataTagGroup;
  switch (allow_.group()) {
  case GroupToken::modelGroup:
    fragment[nFragments++] = Fragments::modelGroup;
    break;
  case GroupToken::dataTagTemplateGroup:
    fragment[nFragments++] = Fragments::dataTagTemplateGroup;
    break;
  default:
    break;
  }
  switch (allow_.nameStart()) {
  case GroupToken::name:
    fragment[nFragments++] = Fragments::name;
    break;
  case GroupToken::nameToken:
    fragment[nFragments++] = Fragments::nameToken;
    break;
  case GroupToken::elementToken:
    fragment[nFragments++] = Fragments::elementToken;
    break;
  default:
    break;
  }
  Boolean first = 1;
  for (int i = 0; i < nFragments; i++) {
    if (!first)
      builder.appendFragment(Fragments::listSep);
    else
      first = 0;
    builder.appendFragment(fragment[i]);
  }
  if (allow_.groupToken(GroupToken::pcdata)) {
    if (!first)
      builder.appendFragment(Fragments::listSep);
    CString pcdata(syntax_->delimGeneral(Syntax::dRNI));
    pcdata += syntax_->reservedName(Syntax::rPCDATA);
    builder.appendChars(pcdata.pointer(), pcdata.length());
  }
}
